const mongoose = require('mongoose');
const chatMessageSchema = new mongoose.Schema({
    userId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User',
    },
    action: {
        type: String,
        required: true,
        maxLength: 255,
    },
    timestamp: {
        type: Date,
        default: Date.now,
    },
    sessionId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'KycSession',
    },
    // resource: {
    //     type: mongoose.Schema.Types.ObjectId,
    //     ref: 'Resource',
    // },
    ipAddress: {
        type: String,
    }

}, {
    timestamps: true,
});
module.exports = mongoose.model('AuditLog', chatMessageSchema);