// const mongoose = require('mongoose');

// const ChatSchema = new mongoose.Schema({
//   meetingId: String,
//   sender: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
//   message: String,
//   type: { type: String, enum: ['text', 'image'], default: 'text' },
//   timestamp: { type: Date, default: Date.now },
// });

// module.exports = mongoose.model('Chat', ChatSchema);
// models/ChatMessage.js
// const mongoose = require('mongoose');
// const { Schema } = mongoose;

// const ChatMessageSchema = new Schema(
//   {
//     meetingId:      { type: Schema.Types.ObjectId, ref: 'Meeting', required: true },
//     participantId:  { type: String },          // Jitsi participant ID or user ID
//     participantName:{ type: String },          // friendly display name

//     /* Message payload */
//     message:        { type: String },          // text or caption
//     messageType:    { type: String, enum: ['text', 'image', 'file'], default: 'text' },

//     /* Attachment metadata (when messageType is image/file) */
//     fileUrl:        { type: String },
//     fileName:       { type: String },

//     timestamp:      { type: Date, default: Date.now }
//   },
//   { timestamps: false } // we already store 'timestamp'
// );

// /* Fast retrieval of all messages for a meeting */
// ChatMessageSchema.index({ meetingId: 1, timestamp: 1 });

// module.exports = mongoose.model('ChatMessage', ChatMessageSchema);



// models/ChatMessage.js
// const mongoose = require('mongoose');

// const chatMessageSchema = new mongoose.Schema({
//   meetingId: {
//     type: String,
//     required: true,
//     index: true
//   },
//   senderName: {
//     type: String,
//     required: true
//   },
//   senderRole: {
//     type: String,
//     enum: ['moderator', 'participant'],
//     default: 'participant'
//   },
//   messageType: {
//     type: String,
//     enum: ['text', 'image', 'video', 'document'],
//     default: 'text'
//   },
//   content: {
//     type: String,
//     required: true
//   },
//   fileUrl: {
//     type: String,
//     required: function() { return this.messageType !== 'text'; }
//   },
//   fileName: {
//     type: String,
//     required: function() { return this.messageType !== 'text'; }
//   },
//   fileSize: {
//     type: Number,
//     required: function() { return this.messageType !== 'text'; }
//   },
//   mimeType: {
//     type: String,
//     required: function() { return this.messageType !== 'text'; }
//   },
//   thumbnailUrl: {
//     type: String,
//     default: null
//   },
//   createdAt: {
//     type: Date,
//     default: Date.now
//   }
// }, {
//   timestamps: true
// });

// // Index for efficient queries
// chatMessageSchema.index({ meetingId: 1, createdAt: 1 });

// module.exports = mongoose.model('ChatMessage', chatMessageSchema);


// models/ChatMessage.js

//Current working version
/** const mongoose = require('mongoose');

const chatMessageSchema = new mongoose.Schema({
  meetingId: {
    type: String,
    required: true,
    index: true
  },
  senderId: {
    type: mongoose.Schema.Types.ObjectId,
    required: false, // Allow anonymous users
    default: null
  },
  senderName: {
    type: String,
    required: true,
    trim: true
  },
  senderRole: {
    type: String,
    enum: ['moderator', 'participant'],
    default: 'participant'
  },
  jitsiFrom: {
    type: String,
    sparse: true // Jitsi user ID
  },
  jitsiMessageId: {
    type: String,
    sparse: true
  },
  messageHash: {
    type: String,
    index: true // For efficient duplicate detection
  },
  messageType: {
    type: String,
    enum: ['text', 'image', 'video', 'document'],
    required: true,
    default: 'text'
  },
  
  // Text message content
  textContent: {
    type: String,
    required: function() { 
      return this.messageType === 'text'; 
    },
    maxlength: 2000 // Reasonable limit for chat messages
  },
  
  // File-related fields (for image/video/document)
  fileUrl: {
    type: String,
    required: function() { 
      return this.messageType !== 'text'; 
    }
  },
  fileName: {
    type: String,
    required: function() { 
      return this.messageType !== 'text'; 
    }
  },
  fileSize: {
    type: Number,
    required: function() { 
      return this.messageType !== 'text'; 
    }
  },
  mimeType: {
    type: String,
    required: function() { 
      return this.messageType !== 'text'; 
    }
  },
  thumbnailUrl: {
    type: String,
    default: null
  },
  
  // Message metadata
  replyTo: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'ChatMessage',
    default: null
  },
  edited: {
    type: Boolean,
    default: false
  },
  editedAt: {
    type: Date,
    default: null
  },
  deleted: {
    type: Boolean,
    default: false
  },
  deletedAt: {
    type: Date,
    default: null
  },
  
  // Jitsi-specific fields
  jitsiMessageId: {
    type: String,
    sparse: true // Allow multiple null values
  },
  
  // Message status
  status: {
    type: String,
    enum: ['sending', 'sent', 'delivered', 'read', 'failed'],
    default: 'sent'
  },
  
  createdAt: {
    type: Date,
    default: Date.now,
    index: true
  },
  updatedAt: {
    type: Date,
    default: Date.now
  }
}, {
  timestamps: true,
  toJSON: { virtuals: true },
  toObject: { virtuals: true }
});

// Indexes for efficient queries
chatMessageSchema.index({ meetingId: 1, createdAt: 1 });
chatMessageSchema.index({ meetingId: 1, messageType: 1 });
chatMessageSchema.index({ senderId: 1, createdAt: -1 });

// Virtual for getting display content
chatMessageSchema.virtual('displayContent').get(function() {
  if (this.messageType === 'text') {
    return this.textContent;
  }
  return `📎 ${this.fileName}`;
});

// Methods
chatMessageSchema.methods.toClientFormat = function() {
  return {
    id: this._id,
    from: this.senderName,
    type: this.messageType,
    text: this.messageType === 'text' ? this.textContent : `📎 ${this.fileName}`,
    fileData: this.messageType !== 'text' ? {
      type: this.messageType,
      name: this.fileName,
      size: this.fileSize,
      mime: this.mimeType,
      url: this.fileUrl,
      thumbnailUrl: this.thumbnailUrl
    } : null,
    time: this.createdAt,
    senderRole: this.senderRole,
    status: this.status,
    edited: this.edited,
    replyTo: this.replyTo
  };
};

module.exports = mongoose.model('ChatMessage', chatMessageSchema); **/

const mongoose = require('mongoose');

const chatMessageSchema = new mongoose.Schema({
  kycSessionId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'KycSession',
    required: true
  },
  senderName: {
    type: String,
    required: true,
    trim: true
  },
  senderRole: {
    type: String,
    enum: ['moderator', 'participant'],
    default: 'participant'
  },
  jitsiFrom: {
    type: String,
    sparse: true // Jitsi user ID
  },
  messageHash: {
    type: String,
    index: true // For efficient duplicate detection
  },
  //This field is managed by the backend while uploading files
  messageType: {
    type: String,
    enum: ['text', 'image', 'video', 'document'],
    required: true,
    default: 'text'
  },
  //This field specifies that Fi aggent is label the media type in chat with what kind of document it is
  docType: {
    type: String,
    enum: ['aadhaar_front', 'aadhaar_back', 'pan_card', 'customer_photo', 'signature', 'video_recording', 'other_document'],
    default: 'other_document'
  },

  // Text message content
  textContent: {
    type: String,
    required: function () {
      return this.messageType === 'text';
    },
    maxlength: 2000 // Reasonable limit for chat messages
  },

  // File-related fields (for image/video/document)
  fileUrl: {
    type: String,
    required: function () {
      return this.messageType !== 'text';
    }
  },
  fileName: {
    type: String,
    required: function () {
      return this.messageType !== 'text';
    }
  },
  fileSize: {
    type: Number,
    required: function () {
      return this.messageType !== 'text';
    }
  },
  mimeType: {
    type: String,
    required: function () {
      return this.messageType !== 'text';
    }
  },
  thumbnailUrl: {
    type: String,
    default: null
  },

  // Message metadata
  // replyTo: {
  //   type: mongoose.Schema.Types.ObjectId,
  //   ref: 'ChatMessage',
  //   default: null
  // },
  // edited: {
  //   type: Boolean,
  //   default: false
  // },
  // editedAt: {
  //   type: Date,
  //   default: null
  // },
  deleted: {
    type: Boolean,
    default: false
  },
  deletedAt: {
    type: Date,
    default: null
  },

  // Jitsi-specific fields
  // jitsiMessageId: {
  //   type: String,
  //   sparse: true // Allow multiple null values
  // },

  // Message status
  status: {
    type: String,
    enum: ['sending', 'sent', 'delivered', 'read', 'failed'],
    default: 'sent'
  },

  createdAt: {
    type: Date,
    default: Date.now,
    index: true
  },
  updatedAt: {
    type: Date,
    default: Date.now
  }
}, {
  timestamps: true,
  toJSON: { virtuals: true },
  toObject: { virtuals: true }
});

// Indexes for efficient queries
chatMessageSchema.index({ kycSessionId: 1, createdAt: 1 });
chatMessageSchema.index({ kycSessionId: 1, messageType: 1 });


// Virtual for getting display content
chatMessageSchema.virtual('displayContent').get(function () {
  if (this.messageType === 'text') {
    return this.textContent;
  }
  return `📎 ${this.fileName}`;
});

// Methods
chatMessageSchema.methods.toClientFormat = function () {
  return {
    id: this._id,
    from: this.senderName,
    type: this.messageType,
    docType: this.docType,
    text: this.messageType === 'text' ? this.textContent : `📎 ${this.fileName}`,
    fileData: this.messageType !== 'text' ? {
      type: this.messageType,
      name: this.fileName,
      size: this.fileSize,
      mime: this.mimeType,
      url: this.fileUrl,
      thumbnailUrl: this.thumbnailUrl
    } : null,
    time: this.createdAt,
    senderRole: this.senderRole,
    status: this.status,
    edited: this.edited,
  };
};

module.exports = mongoose.model('ChatMessage', chatMessageSchema);



