// models/Customer.js
const mongoose = require('mongoose');

const customerSchema = new mongoose.Schema({
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true
  },
  caseNo: {
    type: String,
    required: true,
    maxlength: 100
  },
  name: {
    type: String,
    required: true,
    maxlength: 100
  },
  mobile: {
    type: String,
    required: true,
    maxlength: 15
  },
  dob: Date,
  gender: {
    type: String,
    enum: ['male', 'female', 'other'],
    maxlength: 10
  },
  kycStatus: {
    type: String,
    enum: ['pending', 'approved', 'rejected'],
    default: 'pending'
  },
  createdBy: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User'
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('Customer', customerSchema);
