const mongoose = require('mongoose');

const kycSessionSchema = new mongoose.Schema({
  tenantId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Tenant',
    required: true
  },
  customerId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Customer',
    required: true
  },
  fiUserId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  officerId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User'
  },
  sessionStart: {
    type: Date,
    default: Date.now
  },
  sessionEnd: Date,
//   geoLocation: {
//     latitude: Number,
//     longitude: Number,
//     address: String
//   },
  status: {
    type: String,
    enum: ['initiated', 'in_review', 'approved', 'rejected'],
    default: 'initiated'
  },
  rejectionReason: String,
}, {
  timestamps: true
});

module.exports = mongoose.model('KycSession', kycSessionSchema);
