// const mongoose = require('mongoose');

// const MeetingSchema = new mongoose.Schema({
//   title: String,
//   meetingId: { type: String, unique: true },
//   createdBy: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
//   participants: [
//     {
//       userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
//       role: { type: String, default: 'participant' },
//       deviceInfo: Object,
//       joinedAt: Date,
//     },
//   ],
//   startedAt: Date,
//   endedAt: Date,
// });

// module.exports = mongoose.model('Meeting', MeetingSchema);

// models/Meeting.js
// const mongoose = require('mongoose');

// const MeetingSchema = new mongoose.Schema(
//   {
//     /* Basic identifiers */
//     roomName:      { type: String, required: true, trim: true },
//     roomId:        { type: String, required: true, unique: true }, // e.g. "room_1698248212345"
//     ownerName:     { type: String, required: true, trim: true },

//     /* Descriptive fields */
//     description:   { type: String, trim: true },
    
//     /* Scheduling & validity */
//     scheduledTime:    { type: Date, required: true },
//     validityDuration: { type: Number, required: true }, // minutes
//     expiryTime:       { type: Date, required: true },   // scheduledTime + validityDuration

//     /* Runtime state */
//     status: {
//       type: String,
//       enum: ['scheduled', 'active', 'completed', 'expired'],
//       default: 'scheduled'
//     },
//     participantCount: { type: Number, default: 0 },

//     /* Compliance / media */
//     recordingUrl: { type: String } // populated when Jibri recording finishes
//   },
//   { timestamps: true }             // adds createdAt & updatedAt
// );

// /* Indexes */
// MeetingSchema.index({ roomId: 1 }, { unique: true });
// /* Optional: automatically remove expired meetings/documents
//    after their expiryTime has passed. Comment out if you prefer manual cleanup. */
// // MeetingSchema.index({ expiryTime: 1 }, { expireAfterSeconds: 0 });

// module.exports = mongoose.model('Meeting', MeetingSchema);


// models/Meeting.js - Simplified with URLs and JWT tokens
const { string } = require('joi');
const mongoose = require('mongoose');

const MeetingSchema = new mongoose.Schema({
  roomName: { type: String, required: true, trim: true },
  roomId: { type: String, required: true, unique: true },
  ownerName: { type: String, required: true, trim: true },
  description: { type: String, trim: true },
  scheduledTime: { type: Date, required: true },
  validityDuration: { type: Number, required: true }, // minutes
  expiryTime: { type: Date, required: true },
  
  // Share URLs for different roles
  ownerMeetingUrl: { type: String },      // Owner/Moderator URL
  participantMeetingUrl: { type: String }, // Participant URL
  moderatorToken: { type: String},   
  participantToken: { type: String },
  status: { 
    type: String, 
    enum: ['scheduled', 'active', 'completed', 'expired'], 
    default: 'scheduled' 
  },
  participantCount: { type: Number, default: 0 }
}, { timestamps: true });

// Indexes
// MeetingSchema.index({ roomId: 1 }, { unique: true });
// MeetingSchema.index({ expiryTime: 1 });

module.exports = mongoose.model('Meeting', MeetingSchema);
