const mongoose = require('mongoose');

const resourceSchema = new mongoose.Schema({
  name: {
    type: String,
    required: true,
    unique: true
  },
  displayName: {
    type: String,
    required: true,
  },
  description: {
    type: String,
    maxlength: 255
  },
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true,
  autoCreate: true // Automatically create the collection if it doesn't exist
});

module.exports = mongoose.model('Resource', resourceSchema);

// async function createDefaultResource() {
//   const Resource = mongoose.model('Resource', resourceSchema);
  
//   const defaultResource = await Resource.findOne({ name: 'default_resource' });
//   if (!defaultResource) {
//     await new Resource({
//       name: 'default_resource',
//       disPlayName: 'Default Resource',
//       description: 'This is a default resource',
//       isActive: true
//     }).save();
//   }
// }
// createDefaultResource().then(() => {
//   console.log('Default resource created if it did not exist.')  
//   }).catch(err => {
//     console.error('Error creating default resource:', err)
//     });