const express = require('express');
const router = express.Router();
const checkPermission = require('../middlewares/checkPermissions');
const authentication = require('../middlewares/authMiddleware');
const KycSessionController = require('../controllers/kycSessionController');
const { validateKycSession, updateValidateKycSession } = require("../validations/kycSessionValidation");
// GET /api/kyc-sessions - Get all KYC sessions
router.get('/', authentication, checkPermission('kyc_session', 'view'), KycSessionController.getAllKycSessions);

// GET /api/kyc-sessions/:id - Get KYC session by ID
router.get('/:id', authentication, checkPermission('kyc_session', 'view'), KycSessionController.getKycSessionById);

// POST /api/kyc-sessions - Create new KYC session
router.post('/', authentication, checkPermission('kyc_session', 'add'), validateKycSession, KycSessionController.createKycSession);

// PUT /api/kyc-sessions/:id - Update KYC session
router.put('/:id', authentication, checkPermission('kyc_session', 'update'), updateValidateKycSession, KycSessionController.updateKycSession);

// DELETE /api/kyc-sessions/:id - Soft delete KYC session
router.delete('/:id', authentication, checkPermission('kyc_session', 'delete'), KycSessionController.deleteKycSession);

// GET /api/kyc-sessions/tenant/:tenantId - Get KYC sessions by tenant
// router.get('/tenant/:tenantId', authentication, checkPermission('kyc_sessions', 'view'), KycSessionController.getKycSessionsByTenant);

module.exports = router;