const express = require('express');
const router = express.Router();
const tenantController = require('../controllers/tenantController');
const { validateTenantWithUser } = require('../validations/tenantValidation');
const checkPermission = require("../middlewares/checkPermissions");
const authentication = require('../middlewares/authMiddleware');
//Create new tenent
router.post('/', authentication, checkPermission('tenant', 'add'), validateTenantWithUser, tenantController.createTenant);

//Fetch all the tenants
router.get('/', authentication, checkPermission('tenant', 'view'), tenantController.getAllTenants);

//Fecth a tenant detail by id 
router.get('/:id', authentication, checkPermission('tenant', 'view'), tenantController.getTenantById);

//Upate a tenant detail by id
router.put('/:id', authentication, checkPermission('tenant', 'update'), validateTenantWithUser, tenantController.updateTenant);

module.exports = router;