// const express = require('express');
// const cors = require('cors');
// require('dotenv').config();
// const adminRoutes = require('./routes/adminRoutes');
// const app = express();

// // Middleware
// app.use(cors());
// app.use(express.json());

// // --- API Routes ---

// // Health Check API
// app.get('/api/ping', (req, res) => {
//   res.json({ message: 'Backend API is live!' });
// });

// // Add a placeholder for future routes
// // app.use('/api/auth', require('./routes/authRoutes')); // For JWT
// // app.use('/api/recording', require('./routes/recordingRoutes')); // For Jibri
// // app.use('/api/users', require('./routes/userRoutes')); // For Admin Panel
// // app.use('/api/rooms', require('./routes/roomRoutes')); // For Admin Panel

// app.use('/api/v1', adminRoutes); // Main API routes

// const PORT = process.env.PORT || 5000;
// app.listen(PORT, () => {
//   console.log(`Backend server running on port ${PORT}`);
// });
const express = require('express');
const cors = require('cors');
const dotenv = require('dotenv');
const connectDB = require('./config/db');
const path = require('path');
const roleSchema = require('./models/roleSchema');
const customerSchema = require('./models/customerSchema');
const kycSessionSchema = require('./models/kycSessionSchema');
const kycReviewSchema = require('./models/kycReviewSchema');
const resourceSchema = require('./models/resourceSchema');
dotenv.config();
connectDB().then(async () => {
  console.log('Database connected successfully');
  await roleSchema.createCollection();
  await customerSchema.createCollection();
  await kycSessionSchema.createCollection();
  await kycReviewSchema.createCollection();
  await resourceSchema.createCollection();
}).catch(err => {
  console.error('Database connection failed:', err.message);
  process.exit(1);
});

const app = express();
app.use(express.json());
app.use(cors({
  origin: process.env.FRONTEND_URL || 'http://localhost:3000',
  credentials: true
}));

app.use(express.json({ limit: '30mb' }));
app.use(express.urlencoded({ extended: true, limit: '30mb' }));

// Static file serving for uploaded files
app.use('/uploads', express.static(path.join(__dirname, 'uploads'), {
  // Enable CORS for file access
  setHeaders: (res, path) => {
    res.setHeader('Access-Control-Allow-Origin', '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET');
    res.setHeader('Access-Control-Allow-Headers', 'Content-Type');
    
    // Set appropriate content types
    if (path.endsWith('.jpg') || path.endsWith('.jpeg')) {
      res.setHeader('Content-Type', 'image/jpeg');
    } else if (path.endsWith('.png')) {
      res.setHeader('Content-Type', 'image/png');
    } else if (path.endsWith('.gif')) {
      res.setHeader('Content-Type', 'image/gif');
    } else if (path.endsWith('.webp')) {
      res.setHeader('Content-Type', 'image/webp');
    } else if (path.endsWith('.mp4')) {
      res.setHeader('Content-Type', 'video/mp4');
    } else if (path.endsWith('.webm')) {
      res.setHeader('Content-Type', 'video/webm');
    } else if (path.endsWith('.pdf')) {
      res.setHeader('Content-Type', 'application/pdf');
    }
  }
}));
app.use('/api/v1', require('./routes/routes'));

// Health Check API
app.get('/api/ping', (req, res) => {
  res.json({ message: 'Backend API is live!' });
} );

app.listen(process.env.PORT || 5000, () => {
  console.log(`Backend server running on port ${process.env.PORT || 5000}`);
});

module.exports = app;