import React from 'react';
import { Link, Outlet } from 'react-router-dom';
import './admin.css'; // Admin specific styles

const AdminDashboard = () => {
  return (
    <div className="admin-dashboard">
      <nav className="admin-sidebar">
        <h2>Admin Panel</h2>
        <ul>
          <li><Link to="/admin/users">Users</Link></li>
          <li><Link to="/admin/rooms">Rooms</Link></li>
          <li><Link to="/admin/recordings">Recordings</Link></li>
          <li><Link to="/">Back to Conference</Link></li>
        </ul>
      </nav>
      <div className="admin-content">
        <Outlet /> {/* This is where nested routes will render */}
      </div>
    </div>
  );
};

export default AdminDashboard;