import { useState } from "react";
import "./JitsiLayout.css";

const ChatBox = ({ messages, onSend }) => {
  const [input, setInput] = useState("");

  const sendText = () => {
    if (input.trim()) {
      onSend({ type: "text", message: input });
      setInput("");
    }
  };

  const sendImage = (e) => {
    const file = e.target.files[0];
    if (!file) return;

    const reader = new FileReader();
    reader.onloadend = () => {
      onSend({ type: "image", message: reader.result });
    };
    reader.readAsDataURL(file);
  };

  return (
    <div className="chat-box">
      <div className="chat-header">💬 Chat</div>
      <div className="chat-messages">
        {messages.map((m, idx) => (
          <div key={idx} className="chat-msg">
            <strong>{m.sender || "You"}:</strong>{" "}
            {m.type === "image" ? (
              <img src={m.message} alt="sent" className="chat-img" />
            ) : (
              m.message
            )}
          </div>
        ))}
      </div>
      <div className="chat-input">
        <input
          type="text"
          value={input}
          placeholder="Type a message"
          onChange={(e) => setInput(e.target.value)}
          onKeyDown={(e) => e.key === "Enter" && sendText()}
        />
        <button onClick={sendText}>Send</button>
        <label className="image-upload">
          📷
          <input type="file" accept="image/*" onChange={sendImage} hidden />
        </label>
      </div>
    </div>
  );
};

export default ChatBox;
