import React, { useState, useEffect } from "react";
import { NavLink, useNavigate } from "react-router-dom";
import "./Sidebar.css";
import {
  LayoutDashboard,
  Video,
  MessageSquare,
  Settings,
  Shield,
  LogOut,
  ChevronLeft,
  ChevronRight,
  User,
  Bell,
  HelpCircle,
} from "lucide-react";

const Sidebar = () => {
  // { isMobile, isOpen, onClose }
  // const [isCollapsed, setIsCollapsed] = useState(false);
  const navigate = useNavigate();

  const handleLogout = () => {
    localStorage.removeItem("token");
    navigate("/admin/login");
  };

  const menuItems = [
    {
      path: "/admin/dashboard",
      icon: LayoutDashboard,
      label: "Dashboard",
      badge: null,
    },
    {
      path: "/admin/meetings",
      icon: Video,
      label: "Meetings",
      badge: null,
    },
    {
      path: "/admin/chats",
      icon: MessageSquare,
      label: "Chats",
      badge: null,
    },
    {
      path: "/admin/settings",
      icon: Settings,
      label: "Settings",
      badge: null,
    },
  ];
  // useEffect(() => {
  //   if (isMobile && isOpen) {
  //     // Add event listener for escape key
  //     const handleEscape = (e) => {
  //       if (e.key === "Escape") {
  //         onClose();
  //       }
  //     };

  //     document.addEventListener("keydown", handleEscape);
  //     return () => document.removeEventListener("keydown", handleEscape);
  //   }
  // }, [isMobile, isOpen, onClose]);

  return (
    <aside className={"sidebar"}>
      {/*  ${isCollapsed ? "collapsed" : ""} ${
        isMobile && isOpen ? "mobile-open" : ""
      }` */}
      {/* Header */}
      <div className="sidebar-header">
        <div className="brand-container">
          <div className="brand-icon">
            <Shield size={28} />
          </div>
          {/* {!isCollapsed && (
            <div className="brand-text">
              <h2>Admin Portal</h2>
              <span>Management Hub</span>
            </div>
          )} */}
          <div className="brand-text">
            <h2>Admin Portal</h2>
            <span>Management Hub</span>
          </div>
        </div>

        {/* <button
          className="collapse-btn"
          onClick={() => setIsCollapsed(!isCollapsed)}
          title={isCollapsed ? "Expand sidebar" : "Collapse sidebar"}
        > */}
        {/* {isCollapsed ? <ChevronRight size={20} /> : <ChevronLeft size={20} />} */}
        {/* </button> */}
      </div>

      {/* User Profile Section */}
      <div className="user-profile">
        <div className="avatar">
          <User size={24} />
        </div>
        {/* {!isCollapsed && (
          <div className="user-info">
            <h4>Admin User</h4>
            <span>Administrator</span>
          </div>
        )} */}
        <div className="user-info">
          <h4>Admin User</h4>
          <span>Administrator</span>
        </div>
        {/* {!isCollapsed && (
          <div className="profile-actions">
            <button className="profile-btn" title="Notifications">
              <Bell size={16} />
            </button>
          </div>
        )} */}
        <div className="profile-actions">
          <button className="profile-btn" title="Notifications">
            <Bell size={16} />
          </button>
        </div>
      </div>

      {/* Navigation Menu */}
      <nav className="sidebar-nav">
        <div className="nav-section">
          <span className="nav-label">Main</span>
          {/* {!isCollapsed && <span className="nav-label">Main</span>} */}
          <ul className="nav-list">
            {menuItems.map((item) => {
              const IconComponent = item.icon;
              return (
                <li key={item.path} className="nav-item">
                  <NavLink
                    to={item.path}
                    className={({ isActive }) =>
                      `nav-link ${isActive ? "active" : ""}`
                    }
                    // title={isCollapsed ? item.label : ""}
                  >
                    <div className="nav-icon">
                      <IconComponent size={20} />
                    </div>
                    {/* {!isCollapsed && (
                      <>
                        <span className="nav-text">{item.label}</span>
                        {item.badge && (
                          <span className="nav-badge">{item.badge}</span>
                        )}
                      </>
                    )} */}
                    <span className="nav-text">{item.label}</span>
                    {item.badge && (
                      <span className="nav-badge">{item.badge}</span>
                    )}
                  </NavLink>
                </li>
              );
            })}
          </ul>
        </div>

        {/* Support Section */}
        <div className="nav-section">
          {/* {!isCollapsed && <span className="nav-label">Support</span>} */}
          <span className="nav-label">Support</span>
          <ul className="nav-list">
            <li className="nav-item">
              <button
                className="nav-link support-link"
                // title={isCollapsed ? "Help & Support" : ""}
              >
                <div className="nav-icon">
                  <HelpCircle size={20} />
                </div>
                {/* {!isCollapsed && (
                  <span className="nav-text">Help & Support</span>
                )} */}
                <span className="nav-text">Help & Support</span>
              </button>
            </li>
          </ul>
        </div>
      </nav>

      {/* Footer Actions */}
      <div className="sidebar-footer">
        <button
          className="logout-btn"
          onClick={handleLogout}
          // title={isCollapsed ? "Logout" : ""}
        >
          <LogOut size={20} />
          {/* {!isCollapsed && <span>Logout</span>} */}
          <span>Logout</span>
        </button>
      </div>
    </aside>
  );
};

export default Sidebar;
