import { useEffect, useState } from "react";
import { useForm } from "react-hook-form";
import * as yup from "yup";
import { yupResolver } from "@hookform/resolvers/yup";
import "./Roles.css";
import axiosInstance from "../../config/axiosInstance";

const Roles = () => {
  const [resources, setResources] = useState(null);
  const [apiErr, setApiErr] = useState(null);

  const roleSchema = yup
    .object({
      name: yup.string().required("Role Name is required"),
      description: yup.string().required("Role Description is required"),
      isActive: yup.boolean(),
    })
    .required();
  const {
    register,
    handleSubmit,
    formState: { errors },
  } = useForm({
    resolver: yupResolver(roleSchema),
  });

  const addRole = async (data) => {
    try {
      const response = await axiosInstance.post("/roles", data);

      if (response.status === 200) {
        console.log("ui");
      }
    } catch (error) {
      if (error.response) {
        setApiErr(error.response.data?.message);
      } else if (error.request) {
        setApiErr(
          "No response from server. Please check your internet connection."
        );
      } else {
        setApiErr(error.message || "Something went wrong.");
      }
    }
  };

  // const getResources = async () => {
  //   try {
  //     const response = await axiosInstance.get("/resources");

  //     setResources(response.data);
  //   } catch (error) {
  //     if (error.response) {
  //       setApiErr(error.response.data?.message);
  //     } else if (error.request) {
  //       setApiErr(
  //         "No response from server. Please check your internet connection."
  //       );
  //     } else {
  //       setApiErr(error.message || "Something went wrong.");
  //     }
  //   }
  // };

  // useEffect(() => {
  //   getResources();
  // }, []);

  return (
    <div>
      <h1>Roles & Permission</h1>
      <div className="roles__top-bar">
        <button className="roles__add-role-btn">Add Role</button>
        <div className="popup">
          <form className="form" onSubmit={handleSubmit(addRole)}>
            {apiErr && <p className="server-err">{apiErr}</p>}
            <input
              type="text"
              placeholder="Role Name"
              className="form-input"
              required
              {...register("name")}
            />
            <textarea
              placeholder="Role Description"
              className="form-textarea"
              {...register("description")}
            />
            <div className="form-element">
              <input
                type="checkbox"
                className="form-checkbox"
                {...register("isActive")}
              ></input>
              <label>Is Active</label>
            </div>
            <div className="roles__add-role-resources">
              <div class="roles__resources"></div>
            </div>
            <button type="submit" className={`form-submit`}>
              Save
            </button>
            <button type="submit" className={`form-cancel`}>
              Cancel
            </button>
          </form>
        </div>
      </div>
    </div>
  );
};

export default Roles;
